/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.systems;

import java.util.Locale;
import minecrafttransportsimulator.baseclasses.ComputedVariable;
import minecrafttransportsimulator.baseclasses.EntityInteractResult;
import minecrafttransportsimulator.baseclasses.Point3D;
import minecrafttransportsimulator.entities.components.AEntityB_Existing;
import minecrafttransportsimulator.entities.components.AEntityF_Multipart;
import minecrafttransportsimulator.entities.instances.APart;
import minecrafttransportsimulator.entities.instances.EntityPlacedPart;
import minecrafttransportsimulator.entities.instances.EntityPlayerGun;
import minecrafttransportsimulator.entities.instances.EntityVehicleF_Physics;
import minecrafttransportsimulator.entities.instances.PartEngine;
import minecrafttransportsimulator.entities.instances.PartGun;
import minecrafttransportsimulator.entities.instances.PartSeat;
import minecrafttransportsimulator.guis.components.AGUIBase;
import minecrafttransportsimulator.guis.instances.GUIPanel;
import minecrafttransportsimulator.guis.instances.GUIRadio;
import minecrafttransportsimulator.jsondefs.JSONConfigClient;
import minecrafttransportsimulator.jsondefs.JSONVehicle;
import minecrafttransportsimulator.mcinterface.IWrapperPlayer;
import minecrafttransportsimulator.mcinterface.InterfaceManager;
import minecrafttransportsimulator.packets.instances.PacketEntityCameraChange;
import minecrafttransportsimulator.packets.instances.PacketEntityCustomKeypress;
import minecrafttransportsimulator.packets.instances.PacketEntityInteract;
import minecrafttransportsimulator.packets.instances.PacketEntityInteractGUI;
import minecrafttransportsimulator.packets.instances.PacketEntityVariableIncrement;
import minecrafttransportsimulator.packets.instances.PacketEntityVariableSet;
import minecrafttransportsimulator.packets.instances.PacketEntityVariableToggle;
import minecrafttransportsimulator.packets.instances.PacketPartGun;
import minecrafttransportsimulator.packets.instances.PacketPartSeat;
import minecrafttransportsimulator.packets.instances.PacketVehicleControlNotification;
import minecrafttransportsimulator.systems.ConfigSystem;
import minecrafttransportsimulator.systems.LanguageSystem;

public final class ControlSystem {
    private static final int NULL_COMPONENT = 999;
    private static boolean joysticksInhibited = false;
    private static IWrapperPlayer clientPlayer;
    private static boolean clickingLeft;
    private static boolean clickingRight;
    private static double throttleRequestLastCheck;
    private static double brakeRequestLastCheck;
    private static EntityInteractResult interactResult;

    public static void controlGlobal(IWrapperPlayer player) {
        EntityPlayerGun playerGun = EntityPlayerGun.playerClientGuns.get(player.getID());
        if (InterfaceManager.inputInterface.isLeftMouseButtonDown()) {
            if (!clickingLeft) {
                clickingLeft = true;
                ControlSystem.handleClick(player, playerGun, true, false, false, false);
            }
        } else if (clickingLeft) {
            clickingLeft = false;
            ControlSystem.handleClick(player, playerGun, false, true, false, false);
        }
        if (InterfaceManager.inputInterface.isRightMouseButtonDown()) {
            if (!clickingRight) {
                clickingRight = true;
                ControlSystem.handleClick(player, playerGun, false, false, true, false);
            }
        } else if (clickingRight) {
            clickingRight = false;
            ControlSystem.handleClick(player, playerGun, false, false, false, true);
        }
        if (playerGun != null && playerGun.activeGun != null && !InterfaceManager.clientInterface.isGUIOpen() && ControlsKeyboard.GENERAL_RELOAD.isPressed()) {
            InterfaceManager.packetInterface.sendToServer(new PacketPartGun(playerGun.activeGun, PacketPartGun.Request.RELOAD_HAND));
        }
    }

    private static void handleClick(IWrapperPlayer player, EntityPlayerGun playerGun, boolean leftClickDown, boolean leftClickUp, boolean rightClickDown, boolean rightClickUp) {
        if (playerGun != null && playerGun.activeGun != null) {
            if (leftClickDown) {
                InterfaceManager.packetInterface.sendToServer(new PacketPartGun(playerGun.activeGun, PacketPartGun.Request.TRIGGER_ON));
            } else if (leftClickUp) {
                InterfaceManager.packetInterface.sendToServer(new PacketPartGun(playerGun.activeGun, PacketPartGun.Request.TRIGGER_OFF));
            } else if (rightClickDown) {
                InterfaceManager.packetInterface.sendToServer(new PacketPartGun(playerGun.activeGun, PacketPartGun.Request.AIM_ON));
            } else if (rightClickUp) {
                InterfaceManager.packetInterface.sendToServer(new PacketPartGun(playerGun.activeGun, PacketPartGun.Request.AIM_OFF));
            }
        }
        if (leftClickDown || rightClickDown) {
            Point3D startPosition = player.getEyePosition();
            Point3D endPosition = player.getLineOfSight(3.5).add(startPosition);
            interactResult = player.getWorld().getMultipartEntityIntersect(startPosition, endPosition);
            if (interactResult != null) {
                InterfaceManager.packetInterface.sendToServer(new PacketEntityInteract(ControlSystem.interactResult.entity, player, ControlSystem.interactResult.box, leftClickDown, rightClickDown));
            }
        } else if (interactResult != null) {
            InterfaceManager.packetInterface.sendToServer(new PacketEntityInteract(ControlSystem.interactResult.entity, player, ControlSystem.interactResult.box, false, false));
            interactResult = null;
        }
    }

    public static void controlMultipart(AEntityF_Multipart<?> multipart, boolean isPlayerController) {
        clientPlayer = InterfaceManager.clientInterface.getClientPlayer();
        if (multipart instanceof EntityVehicleF_Physics) {
            EntityVehicleF_Physics vehicle = (EntityVehicleF_Physics)multipart;
            if (((JSONVehicle)vehicle.definition).motorized.isAircraft) {
                ControlSystem.controlAircraft(vehicle, isPlayerController);
            } else {
                ControlSystem.controlGroundVehicle(vehicle, isPlayerController);
            }
        } else if (multipart instanceof EntityPlacedPart) {
            ControlSystem.controlCamera(ControlsKeyboard.CAR_ZOOM_I, ControlsKeyboard.CAR_ZOOM_O, ControlsKeyboard.CAR_CHANGEVIEW, ControlsJoystick.CAR_LOOK_UD, ControlsJoystick.CAR_LOOK_LR);
            ControlSystem.rotateCamera(ControlsJoystick.CAR_LOOK_R, ControlsJoystick.CAR_LOOK_L, ControlsJoystick.CAR_LOOK_U, ControlsJoystick.CAR_LOOK_D, ControlsJoystick.CAR_LOOK_A);
            ControlSystem.controlGun(multipart, ControlsKeyboard.CAR_GUN_FIRE, ControlsKeyboard.CAR_GUN_SWITCH);
        }
        if (ControlsKeyboard.GENERAL_CUSTOM1.isPressed()) {
            InterfaceManager.packetInterface.sendToServer(new PacketEntityCustomKeypress(multipart, 1, true));
        } else if (ControlsKeyboard.GENERAL_CUSTOM1.justReleased()) {
            InterfaceManager.packetInterface.sendToServer(new PacketEntityCustomKeypress(multipart, 1, false));
        }
        if (ControlsKeyboard.GENERAL_CUSTOM2.isPressed()) {
            InterfaceManager.packetInterface.sendToServer(new PacketEntityCustomKeypress(multipart, 2, true));
        } else if (ControlsKeyboard.GENERAL_CUSTOM2.justReleased()) {
            InterfaceManager.packetInterface.sendToServer(new PacketEntityCustomKeypress(multipart, 2, false));
        }
        if (ControlsKeyboard.GENERAL_CUSTOM3.isPressed()) {
            InterfaceManager.packetInterface.sendToServer(new PacketEntityCustomKeypress(multipart, 3, true));
        } else if (ControlsKeyboard.GENERAL_CUSTOM3.justReleased()) {
            InterfaceManager.packetInterface.sendToServer(new PacketEntityCustomKeypress(multipart, 3, false));
        }
        if (ControlsKeyboard.GENERAL_CUSTOM4.isPressed()) {
            InterfaceManager.packetInterface.sendToServer(new PacketEntityCustomKeypress(multipart, 4, true));
        } else if (ControlsKeyboard.GENERAL_CUSTOM4.justReleased()) {
            InterfaceManager.packetInterface.sendToServer(new PacketEntityCustomKeypress(multipart, 4, false));
        }
    }

    private static void controlCamera(ControlsKeyboard zoomIn, ControlsKeyboard zoomOut, ControlsKeyboard changeView, ControlsJoystick viewUD, ControlsJoystick viewLR) {
        AEntityB_Existing riding = clientPlayer.getEntityRiding();
        if (riding instanceof PartSeat) {
            PartSeat sittingSeat = (PartSeat)riding;
            if (zoomIn.isPressed()) {
                InterfaceManager.packetInterface.sendToServer(new PacketPartSeat(sittingSeat, PacketPartSeat.SeatAction.ZOOM_IN));
            }
            if (zoomOut.isPressed()) {
                InterfaceManager.packetInterface.sendToServer(new PacketPartSeat(sittingSeat, PacketPartSeat.SeatAction.ZOOM_OUT));
            }
            if (changeView.isPressed()) {
                InterfaceManager.packetInterface.sendToServer(new PacketEntityCameraChange(sittingSeat));
            }
            if (!viewLR.isJoystickActive() && !viewUD.isJoystickActive()) {
                riding.hasHeadTracking = false;
                riding.headTrackingOrientation.set(0.0, 0.0, 0.0);
            } else {
                riding.hasHeadTracking = true;
                riding.headTrackingOrientation.x = -(viewUD.getAxisState(true) - 0.5) * 170.0;
                riding.headTrackingOrientation.y = -(viewLR.getAxisState(true) - 0.5) * 180.0;
            }
        }
    }

    private static void rotateCamera(ControlsJoystick lookR, ControlsJoystick lookL, ControlsJoystick lookU, ControlsJoystick lookD, ControlsJoystick lookA) {
        float pollData;
        if (lookR.isPressed()) {
            clientPlayer.setYaw(clientPlayer.getYaw() - 3.0f);
        }
        if (lookL.isPressed()) {
            clientPlayer.setYaw(clientPlayer.getYaw() + 3.0f);
        }
        if (lookU.isPressed()) {
            clientPlayer.setPitch(clientPlayer.getPitch() - 3.0f);
        }
        if (lookD.isPressed()) {
            clientPlayer.setPitch(clientPlayer.getPitch() + 3.0f);
        }
        if ((pollData = lookA.getMultistateValue()) != 0.0f) {
            if (pollData >= 0.125f && pollData <= 0.375f) {
                clientPlayer.setPitch(clientPlayer.getPitch() + 3.0f);
            }
            if (pollData >= 0.375f && pollData <= 0.625f) {
                clientPlayer.setYaw(clientPlayer.getYaw() - 3.0f);
            }
            if (pollData >= 0.625f && pollData <= 0.875f) {
                clientPlayer.setPitch(clientPlayer.getPitch() - 3.0f);
            }
            if (pollData >= 0.875f || pollData <= 0.125f) {
                clientPlayer.setYaw(clientPlayer.getYaw() + 3.0f);
            }
        }
    }

    private static void controlBrake(EntityVehicleF_Physics vehicle, ControlsJoystick joystickBrakeAxis, ControlsJoystick joystickBrakeButton, ControlsKeyboard keyboardBrakeButton, ControlsKeyboard parkingBrakeButton) {
        double brakeValue;
        if (parkingBrakeButton.isPressed()) {
            InterfaceManager.packetInterface.sendToServer(new PacketEntityVariableToggle(vehicle.parkingBrakeVar));
        }
        double d = joystickBrakeAxis.isJoystickActive() ? joystickBrakeAxis.getAxisState(true) : (brakeValue = joystickBrakeButton.isPressed() || keyboardBrakeButton.isPressed() ? 1.0 : 0.0);
        if (brakeValue != brakeRequestLastCheck) {
            InterfaceManager.packetInterface.sendToServer(new PacketEntityVariableSet(vehicle.brakeVar, brakeValue));
        }
        brakeRequestLastCheck = brakeValue;
    }

    private static void controlGun(AEntityF_Multipart<?> multipart, ControlsKeyboard gunTrigger, ControlsKeyboard gunSwitch) {
        boolean gunSwitchPressedThisScan = gunSwitch.isPressed();
        for (APart part : multipart.allParts) {
            if (part instanceof PartGun) {
                PartGun gun = (PartGun)part;
                if (!clientPlayer.equals(gun.getGunController())) continue;
                if (gunTrigger.isPressed()) {
                    InterfaceManager.packetInterface.sendToServer(new PacketPartGun(gun, PacketPartGun.Request.TRIGGER_ON));
                    continue;
                }
                InterfaceManager.packetInterface.sendToServer(new PacketPartGun(gun, PacketPartGun.Request.TRIGGER_OFF));
                continue;
            }
            if (!(part instanceof PartSeat) || !gunSwitchPressedThisScan || !clientPlayer.equals(part.rider)) continue;
            InterfaceManager.packetInterface.sendToServer(new PacketPartSeat((PartSeat)part, PacketPartSeat.SeatAction.CHANGE_GUN));
        }
    }

    private static void controlPanel(EntityVehicleF_Physics vehicle, ControlsKeyboard panel) {
        if (panel.isPressed() && vehicle.canPlayerStartEngines(clientPlayer)) {
            if (AGUIBase.activeInputGUI instanceof GUIPanel && !AGUIBase.activeInputGUI.editingText) {
                AGUIBase.activeInputGUI.close();
            } else if (!InterfaceManager.clientInterface.isGUIOpen()) {
                new GUIPanel(vehicle);
            }
        }
    }

    private static void controlRadio(EntityVehicleF_Physics vehicle, ControlsKeyboard radio) {
        if (radio.isPressed()) {
            if (AGUIBase.activeInputGUI instanceof GUIRadio) {
                AGUIBase.activeInputGUI.close();
            } else if (!InterfaceManager.clientInterface.isGUIOpen()) {
                new GUIRadio(vehicle.radio);
                InterfaceManager.packetInterface.sendToServer(new PacketEntityInteractGUI(vehicle, InterfaceManager.clientInterface.getClientPlayer(), true));
            }
        }
    }

    private static void controlJoystick(EntityVehicleF_Physics vehicle, ControlsKeyboard joystickInhibit) {
        if (joystickInhibit.isPressed()) {
            joysticksInhibited = !joysticksInhibited;
        }
    }

    private static void controlControlSurface(EntityVehicleF_Physics vehicle, ControlsJoystick axis, ControlsKeyboard increment, ControlsKeyboard decrement, double rate, double bounds, ComputedVariable variable, double dampenRate) {
        if (axis.isJoystickActive()) {
            double axisValue = axis.getAxisState(false);
            if (axisValue == 0.0) {
                InterfaceManager.packetInterface.sendToServer(new PacketEntityVariableSet(variable, 0.0));
            } else {
                InterfaceManager.packetInterface.sendToServer(new PacketEntityVariableSet(variable, bounds * (-1.0 + 2.0 * axisValue)));
            }
        } else if (increment.isPressed()) {
            InterfaceManager.packetInterface.sendToServer(new PacketEntityVariableIncrement(variable, rate * (double)(variable.currentValue < 0.0 ? 2 : 1), -bounds, bounds));
            InterfaceManager.packetInterface.sendToServer(new PacketVehicleControlNotification(vehicle, clientPlayer));
        } else if (decrement.isPressed()) {
            InterfaceManager.packetInterface.sendToServer(new PacketEntityVariableIncrement(variable, -rate * (double)(variable.currentValue > 0.0 ? 2 : 1), -bounds, bounds));
            InterfaceManager.packetInterface.sendToServer(new PacketVehicleControlNotification(vehicle, clientPlayer));
        } else if (clientPlayer.equals(vehicle.lastController)) {
            if (variable.currentValue > dampenRate) {
                InterfaceManager.packetInterface.sendToServer(new PacketEntityVariableIncrement(variable, -dampenRate, 0.0, bounds));
            } else if (variable.currentValue < -dampenRate) {
                InterfaceManager.packetInterface.sendToServer(new PacketEntityVariableIncrement(variable, dampenRate, -bounds, 0.0));
            } else if (variable.currentValue != 0.0) {
                InterfaceManager.packetInterface.sendToServer(new PacketEntityVariableSet(variable, 0.0));
            }
        }
    }

    private static void controlControlTrim(EntityVehicleF_Physics vehicle, ControlsJoystick increment, ControlsJoystick decrement, double bounds, ComputedVariable variable) {
        if (increment.isPressed()) {
            InterfaceManager.packetInterface.sendToServer(new PacketEntityVariableIncrement(variable, 0.1, -bounds, bounds));
        } else if (decrement.isPressed()) {
            InterfaceManager.packetInterface.sendToServer(new PacketEntityVariableIncrement(variable, -0.1, -bounds, bounds));
        }
    }

    private static void controlAircraft(EntityVehicleF_Physics aircraft, boolean isPlayerController) {
        ControlSystem.controlCamera(ControlsKeyboard.AIRCRAFT_ZOOM_I, ControlsKeyboard.AIRCRAFT_ZOOM_O, ControlsKeyboard.AIRCRAFT_CHANGEVIEW, ControlsJoystick.AIRCRAFT_LOOK_UD, ControlsJoystick.AIRCRAFT_LOOK_LR);
        ControlSystem.rotateCamera(ControlsJoystick.AIRCRAFT_LOOK_R, ControlsJoystick.AIRCRAFT_LOOK_L, ControlsJoystick.AIRCRAFT_LOOK_U, ControlsJoystick.AIRCRAFT_LOOK_D, ControlsJoystick.AIRCRAFT_LOOK_A);
        ControlSystem.controlGun(aircraft, ControlsKeyboard.AIRCRAFT_GUN_FIRE, ControlsKeyboard.AIRCRAFT_GUN_SWITCH);
        ControlSystem.controlRadio(aircraft, ControlsKeyboard.AIRCRAFT_RADIO);
        ControlSystem.controlJoystick(aircraft, ControlsKeyboard.AIRCRAFT_JS_INHIBIT);
        if (!isPlayerController) {
            return;
        }
        ControlSystem.controlPanel(aircraft, ControlsKeyboard.AIRCRAFT_PANEL);
        ControlSystem.controlBrake(aircraft, ControlsJoystick.AIRCRAFT_BRAKE, ControlsJoystick.AIRCRAFT_BRAKE_DIGITAL, ControlsKeyboard.AIRCRAFT_BRAKE, ControlsKeyboard.AIRCRAFT_PARK);
        if (ControlsJoystick.AIRCRAFT_REVERSE.isPressed()) {
            InterfaceManager.packetInterface.sendToServer(new PacketEntityVariableToggle(aircraft.reverseThrustVar));
        }
        if (ControlsJoystick.AIRCRAFT_GEAR.isPressed()) {
            InterfaceManager.packetInterface.sendToServer(new PacketEntityVariableToggle(aircraft.retractGearVar));
        }
        if (ControlsJoystick.AIRCRAFT_THROTTLE.isJoystickActive()) {
            InterfaceManager.packetInterface.sendToServer(new PacketEntityVariableSet(aircraft.throttleVar, ControlsJoystick.AIRCRAFT_THROTTLE.getAxisState(true) * 1.0));
        } else {
            if (ControlsKeyboard.AIRCRAFT_THROTTLE_U.isPressed()) {
                InterfaceManager.packetInterface.sendToServer(new PacketEntityVariableIncrement(aircraft.throttleVar, 0.01, 0.0, 1.0));
            }
            if (ControlsKeyboard.AIRCRAFT_THROTTLE_D.isPressed()) {
                InterfaceManager.packetInterface.sendToServer(new PacketEntityVariableIncrement(aircraft.throttleVar, -0.01, 0.0, 1.0));
            }
        }
        if (((JSONVehicle)aircraft.definition).motorized.flapNotches != null && !((JSONVehicle)aircraft.definition).motorized.flapNotches.isEmpty()) {
            if (ControlsKeyboard.AIRCRAFT_FLAPS_D.isPressed()) {
                int currentFlapSetting = ((JSONVehicle)aircraft.definition).motorized.flapNotches.indexOf(Float.valueOf((float)aircraft.flapDesiredAngleVar.currentValue));
                if (currentFlapSetting == -1) {
                    for (int i = 0; i < ((JSONVehicle)aircraft.definition).motorized.flapNotches.size(); ++i) {
                        float flapNotch = ((JSONVehicle)aircraft.definition).motorized.flapNotches.get(i).floatValue();
                        if (!((double)flapNotch > aircraft.flapDesiredAngleVar.currentValue)) continue;
                        currentFlapSetting = i;
                        break;
                    }
                }
                if (currentFlapSetting != -1 && currentFlapSetting + 1 < ((JSONVehicle)aircraft.definition).motorized.flapNotches.size()) {
                    InterfaceManager.packetInterface.sendToServer(new PacketEntityVariableSet(aircraft.flapDesiredAngleVar, ((JSONVehicle)aircraft.definition).motorized.flapNotches.get(currentFlapSetting + 1).floatValue()));
                }
            } else if (ControlsKeyboard.AIRCRAFT_FLAPS_U.isPressed()) {
                int currentFlapSetting = ((JSONVehicle)aircraft.definition).motorized.flapNotches.indexOf(Float.valueOf((float)aircraft.flapDesiredAngleVar.currentValue));
                if (currentFlapSetting == -1) {
                    for (int i = ((JSONVehicle)aircraft.definition).motorized.flapNotches.size() - 1; i <= 0; --i) {
                        float flapNotch = ((JSONVehicle)aircraft.definition).motorized.flapNotches.get(i).floatValue();
                        if (!((double)flapNotch < aircraft.flapDesiredAngleVar.currentValue)) continue;
                        currentFlapSetting = i;
                        break;
                    }
                }
                if (currentFlapSetting > 0) {
                    InterfaceManager.packetInterface.sendToServer(new PacketEntityVariableSet(aircraft.flapDesiredAngleVar, ((JSONVehicle)aircraft.definition).motorized.flapNotches.get(currentFlapSetting - 1).floatValue()));
                }
            }
        }
        if (!((JSONVehicle)aircraft.definition).motorized.isBlimp) {
            ControlSystem.controlControlSurface(aircraft, ControlsJoystick.AIRCRAFT_YAW, ControlsKeyboard.AIRCRAFT_YAW_R, ControlsKeyboard.AIRCRAFT_YAW_L, (Double)ConfigSystem.client.controlSettings.steeringControlRate.value, 45.0, aircraft.rudderInputVar, 2.0);
            ControlSystem.controlControlTrim(aircraft, ControlsJoystick.AIRCRAFT_TRIM_YAW_R, ControlsJoystick.AIRCRAFT_TRIM_YAW_L, 10.0, aircraft.rudderTrimVar);
        }
        ControlSystem.controlControlSurface(aircraft, ControlsJoystick.AIRCRAFT_PITCH, ControlsKeyboard.AIRCRAFT_PITCH_U, ControlsKeyboard.AIRCRAFT_PITCH_D, (Double)ConfigSystem.client.controlSettings.flightControlRate.value, 25.0, aircraft.elevatorInputVar, 0.6);
        ControlSystem.controlControlTrim(aircraft, ControlsJoystick.AIRCRAFT_TRIM_PITCH_U, ControlsJoystick.AIRCRAFT_TRIM_PITCH_D, 10.0, aircraft.elevatorTrimVar);
        if (((JSONVehicle)aircraft.definition).motorized.isBlimp) {
            ControlSystem.controlControlSurface(aircraft, ControlsJoystick.AIRCRAFT_ROLL, ControlsKeyboard.AIRCRAFT_ROLL_R, ControlsKeyboard.AIRCRAFT_ROLL_L, (Double)ConfigSystem.client.controlSettings.steeringControlRate.value, 45.0, aircraft.rudderInputVar, 2.0);
        } else {
            ControlSystem.controlControlSurface(aircraft, ControlsJoystick.AIRCRAFT_ROLL, ControlsKeyboard.AIRCRAFT_ROLL_R, ControlsKeyboard.AIRCRAFT_ROLL_L, (Double)ConfigSystem.client.controlSettings.flightControlRate.value, 25.0, aircraft.aileronInputVar, 0.6);
        }
        ControlSystem.controlControlTrim(aircraft, ControlsJoystick.AIRCRAFT_TRIM_ROLL_R, ControlsJoystick.AIRCRAFT_TRIM_ROLL_L, 10.0, aircraft.aileronTrimVar);
        if ((Boolean)ConfigSystem.client.controlSettings.heliAutoLevel.value ^ aircraft.autolevelEnabledVar.isActive) {
            InterfaceManager.packetInterface.sendToServer(new PacketEntityVariableSet(aircraft.autolevelEnabledVar, (Boolean)ConfigSystem.client.controlSettings.heliAutoLevel.value != false ? 1.0 : 0.0));
        }
    }

    private static void controlGroundVehicle(EntityVehicleF_Physics powered, boolean isPlayerController) {
        ControlSystem.controlCamera(ControlsKeyboard.CAR_ZOOM_I, ControlsKeyboard.CAR_ZOOM_O, ControlsKeyboard.CAR_CHANGEVIEW, ControlsJoystick.CAR_LOOK_UD, ControlsJoystick.CAR_LOOK_LR);
        ControlSystem.rotateCamera(ControlsJoystick.CAR_LOOK_R, ControlsJoystick.CAR_LOOK_L, ControlsJoystick.CAR_LOOK_U, ControlsJoystick.CAR_LOOK_D, ControlsJoystick.CAR_LOOK_A);
        ControlSystem.controlGun(powered, ControlsKeyboard.CAR_GUN_FIRE, ControlsKeyboard.CAR_GUN_SWITCH);
        ControlSystem.controlRadio(powered, ControlsKeyboard.CAR_RADIO);
        ControlSystem.controlJoystick(powered, ControlsKeyboard.CAR_JS_INHIBIT);
        if (!isPlayerController) {
            return;
        }
        ControlSystem.controlPanel(powered, ControlsKeyboard.CAR_PANEL);
        if (((JSONVehicle)powered.definition).motorized.hasIncrementalThrottle) {
            ControlSystem.controlBrake(powered, ControlsJoystick.CAR_BRAKE, ControlsJoystick.CAR_BRAKE_DIGITAL, ControlsKeyboard.CAR_BRAKE, ControlsKeyboard.CAR_PARK);
            if (ControlsJoystick.CAR_GAS.isJoystickActive()) {
                double throttleLevel = ControlsJoystick.CAR_GAS.getAxisState(true) * 1.0;
                if (!powered.autopilotValueVar.isActive || powered.throttleVar.currentValue < throttleLevel) {
                    InterfaceManager.packetInterface.sendToServer(new PacketEntityVariableSet(powered.throttleVar, throttleLevel));
                }
            } else {
                if (ControlsKeyboard.CAR_GAS.isPressed()) {
                    InterfaceManager.packetInterface.sendToServer(new PacketEntityVariableIncrement(powered.throttleVar, 0.01, 0.0, 1.0));
                }
                if (ControlsKeyboard.CAR_BRAKE.isPressed() || ControlsJoystick.CAR_BRAKE_DIGITAL.isPressed()) {
                    InterfaceManager.packetInterface.sendToServer(new PacketEntityVariableIncrement(powered.throttleVar, -0.01, 0.0, 1.0));
                }
            }
        } else {
            double throttleRequest = -999.0;
            if (((Boolean)ConfigSystem.client.controlSettings.simpleThrottle.value).booleanValue()) {
                if (!powered.engines.isEmpty()) {
                    double brakeRequest = -999.0;
                    double brakeValue = ControlsJoystick.CAR_BRAKE.isJoystickActive() ? ControlsJoystick.CAR_BRAKE.getAxisState(true) : (ControlsKeyboard.CAR_BRAKE.isPressed() || ControlsJoystick.CAR_BRAKE_DIGITAL.isPressed() ? 1.0 : 0.0);
                    double throttleValue = ControlsJoystick.CAR_GAS.isJoystickActive() ? ControlsJoystick.CAR_GAS.getAxisState(true) * 1.0 : (ControlsKeyboardDynamic.CAR_SLOW.isPressed() ? ((Boolean)ConfigSystem.client.controlSettings.halfThrottle.value != false ? 1.0 : 0.5) : (ControlsKeyboard.CAR_GAS.isPressed() ? ((Boolean)ConfigSystem.client.controlSettings.halfThrottle.value != false ? 0.5 : 1.0) : 0.0));
                    if (throttleValue == 0.0 && brakeValue == 0.0 && powered.axialVelocity < (double)0.35f) {
                        throttleRequest = 0.0;
                        brakeRequest = 1.0;
                    } else if (((PartEngine)powered.engines.get((int)0)).currentGearVar.currentValue >= 0.0 || ((Boolean)ConfigSystem.client.controlSettings.useShifter.value).booleanValue()) {
                        brakeRequest = brakeValue;
                        if (!powered.autopilotValueVar.isActive || throttleValue > 0.0 || throttleRequestLastCheck > 0.0) {
                            throttleRequest = throttleValue;
                        }
                    } else {
                        throttleRequest = brakeValue;
                        brakeRequest = throttleValue;
                    }
                    if (!((Boolean)ConfigSystem.client.controlSettings.useShifter.value).booleanValue()) {
                        powered.engines.forEach(engine -> {
                            if (brakeValue > 0.25 && engine.currentGearVar.currentValue >= 0.0 && powered.axialVelocity < (double)0.01f) {
                                InterfaceManager.packetInterface.sendToServer(new PacketEntityVariableSet(engine.shiftDownVar, 1.0));
                            } else if (throttleValue > 0.25 && engine.currentGearVar.currentValue <= 0.0 && powered.axialVelocity < (double)0.01f) {
                                InterfaceManager.packetInterface.sendToServer(new PacketEntityVariableSet(engine.shiftUpVar, 1.0));
                            }
                        });
                    }
                    if (brakeRequest != -999.0 && brakeRequestLastCheck != brakeRequest) {
                        InterfaceManager.packetInterface.sendToServer(new PacketEntityVariableSet(powered.brakeVar, brakeRequest));
                    }
                    brakeRequestLastCheck = brakeRequest;
                }
            } else {
                ControlSystem.controlBrake(powered, ControlsJoystick.CAR_BRAKE, ControlsJoystick.CAR_BRAKE_DIGITAL, ControlsKeyboard.CAR_BRAKE, ControlsKeyboard.CAR_PARK);
                if (ControlsJoystick.CAR_GAS.isJoystickActive()) {
                    double throttleLevel = ControlsJoystick.CAR_GAS.getAxisState(true);
                    if (!powered.autopilotValueVar.isActive || throttleLevel > powered.throttleVar.currentValue) {
                        InterfaceManager.packetInterface.sendToServer(new PacketEntityVariableSet(powered.throttleVar, throttleLevel));
                    }
                } else if (ControlsKeyboardDynamic.CAR_SLOW.isPressed()) {
                    throttleRequest = !((Boolean)ConfigSystem.client.controlSettings.halfThrottle.value).booleanValue() ? 0.5 : 1.0;
                } else if (ControlsKeyboard.CAR_GAS.isPressed()) {
                    throttleRequest = !((Boolean)ConfigSystem.client.controlSettings.halfThrottle.value).booleanValue() ? 1.0 : 0.5;
                } else if (!powered.autopilotValueVar.isActive || throttleRequestLastCheck > 0.0) {
                    throttleRequest = 0.0;
                }
            }
            if (throttleRequest != -999.0 && throttleRequestLastCheck != throttleRequest) {
                InterfaceManager.packetInterface.sendToServer(new PacketEntityVariableSet(powered.throttleVar, throttleRequest));
            }
            if (throttleRequest > 0.0 && powered.brakeVar.currentValue > 0.0) {
                InterfaceManager.packetInterface.sendToServer(new PacketEntityVariableSet(powered.brakeVar, 0.0));
            }
            throttleRequestLastCheck = throttleRequest;
        }
        if (!powered.lockedOnRoad) {
            ControlSystem.controlControlSurface(powered, ControlsJoystick.CAR_TURN, ControlsKeyboard.CAR_TURN_R, ControlsKeyboard.CAR_TURN_L, (Double)ConfigSystem.client.controlSettings.steeringControlRate.value, 45.0, powered.rudderInputVar, (Double)ConfigSystem.client.controlSettings.steeringReturnRate.value);
        }
        if (((Boolean)ConfigSystem.client.controlSettings.useShifter.value).booleanValue()) {
            int gearNumber = ControlsJoystick.CAR_SHIFT_1.isPressed() ? 1 : (ControlsJoystick.CAR_SHIFT_2.isPressed() ? 2 : (ControlsJoystick.CAR_SHIFT_3.isPressed() ? 3 : (ControlsJoystick.CAR_SHIFT_4.isPressed() ? 4 : (ControlsJoystick.CAR_SHIFT_5.isPressed() ? 5 : (ControlsJoystick.CAR_SHIFT_6.isPressed() ? 6 : (ControlsJoystick.CAR_SHIFT_7.isPressed() ? 7 : (ControlsJoystick.CAR_SHIFT_8.isPressed() ? 8 : (ControlsJoystick.CAR_SHIFT_9.isPressed() ? 9 : (ControlsJoystick.CAR_SHIFT_R.isPressed() ? 10 : 11)))))))));
            powered.engines.forEach(engine -> InterfaceManager.packetInterface.sendToServer(new PacketEntityVariableSet(engine.shiftSelectionVar, gearNumber)));
        } else if (ControlsKeyboardDynamic.CAR_SHIFT_NU.isPressed() || ControlsKeyboardDynamic.CAR_SHIFT_ND.isPressed()) {
            powered.engines.forEach(engine -> InterfaceManager.packetInterface.sendToServer(new PacketEntityVariableToggle(engine.shiftNeutralVar)));
        } else {
            if (ControlsKeyboard.CAR_SHIFT_U.isPressed()) {
                powered.engines.forEach(engine -> {
                    if (engine.isAutomaticVar.isActive) {
                        if (engine.currentGearVar.currentValue < 0.0) {
                            InterfaceManager.packetInterface.sendToServer(new PacketEntityVariableToggle(engine.shiftNeutralVar));
                        } else if (engine.currentGearVar.currentValue == 0.0) {
                            InterfaceManager.packetInterface.sendToServer(new PacketEntityVariableToggle(engine.shiftUpVar));
                        }
                    } else {
                        InterfaceManager.packetInterface.sendToServer(new PacketEntityVariableToggle(engine.shiftUpVar));
                    }
                });
            }
            if (ControlsKeyboard.CAR_SHIFT_D.isPressed()) {
                powered.engines.forEach(engine -> {
                    if (engine.isAutomaticVar.isActive) {
                        if (engine.currentGearVar.currentValue > 0.0) {
                            InterfaceManager.packetInterface.sendToServer(new PacketEntityVariableToggle(engine.shiftNeutralVar));
                        } else if (engine.currentGearVar.currentValue == 0.0) {
                            InterfaceManager.packetInterface.sendToServer(new PacketEntityVariableToggle(engine.shiftDownVar));
                        }
                    } else {
                        InterfaceManager.packetInterface.sendToServer(new PacketEntityVariableToggle(engine.shiftDownVar));
                    }
                });
            }
        }
        if (ControlsKeyboard.CAR_HORN.isPressed()) {
            InterfaceManager.packetInterface.sendToServer(new PacketEntityVariableSet(powered.hornVar, 1.0));
        } else if (ControlsKeyboard.CAR_HORN.justReleased()) {
            InterfaceManager.packetInterface.sendToServer(new PacketEntityVariableSet(powered.hornVar, 0.0));
        }
        if (ControlsKeyboard.CAR_LIGHTS.isPressed()) {
            InterfaceManager.packetInterface.sendToServer(new PacketEntityVariableToggle(powered.runningLightVar));
            InterfaceManager.packetInterface.sendToServer(new PacketEntityVariableToggle(powered.headLightVar));
        }
        if (ControlsKeyboard.CAR_TURNSIGNAL_L.isPressed()) {
            InterfaceManager.packetInterface.sendToServer(new PacketEntityVariableToggle(powered.leftTurnLightVar));
        }
        if (ControlsKeyboard.CAR_TURNSIGNAL_R.isPressed()) {
            InterfaceManager.packetInterface.sendToServer(new PacketEntityVariableToggle(powered.rightTurnLightVar));
        }
        if (((Boolean)ConfigSystem.client.controlSettings.autoTrnSignals.value).booleanValue()) {
            if (!powered.turningLeft && powered.rudderInputVar.currentValue < -20.0) {
                powered.turningLeft = true;
                powered.turningCooldown = (byte)40;
                InterfaceManager.packetInterface.sendToServer(new PacketEntityVariableToggle(powered.leftTurnLightVar));
            }
            if (!powered.turningRight && powered.rudderInputVar.currentValue > 20.0) {
                powered.turningRight = true;
                powered.turningCooldown = (byte)40;
                InterfaceManager.packetInterface.sendToServer(new PacketEntityVariableToggle(powered.rightTurnLightVar));
            }
            if (powered.turningLeft && (powered.rudderInputVar.currentValue > 0.0 || powered.turningCooldown == 0)) {
                powered.turningLeft = false;
                InterfaceManager.packetInterface.sendToServer(new PacketEntityVariableToggle(powered.leftTurnLightVar));
            }
            if (powered.turningRight && (powered.rudderInputVar.currentValue < 0.0 || powered.turningCooldown == 0)) {
                powered.turningRight = false;
                InterfaceManager.packetInterface.sendToServer(new PacketEntityVariableToggle(powered.rightTurnLightVar));
            }
            if (powered.velocity != 0.0 && powered.turningCooldown > 0 && powered.rudderInputVar.currentValue == 0.0) {
                powered.turningCooldown = (byte)(powered.turningCooldown - 1);
            }
        }
    }

    static {
        clickingLeft = false;
        clickingRight = false;
        interactResult = null;
        for (ControlsJoystick controlsJoystick : ControlsJoystick.values()) {
            ConfigSystem.client.controls.joystick.put(controlsJoystick.systemName, controlsJoystick.config);
        }
        for (Enum enum_ : ControlsKeyboard.values()) {
            ConfigSystem.client.controls.keyboard.put(((ControlsKeyboard)enum_).systemName, ((ControlsKeyboard)enum_).config);
        }
        for (Enum enum_ : ControlsKeyboard.values()) {
            if (((ControlsKeyboard)enum_).config.keyCode > 0) continue;
            ((ControlsKeyboard)enum_).config.keyCode = InterfaceManager.inputInterface.getKeyCodeForName(((ControlsKeyboard)enum_).defaultKeyName);
        }
        ConfigSystem.saveToDisk();
    }

    public static enum ControlsKeyboard {
        GENERAL_CUSTOM1(ControlsJoystick.GENERAL_CUSTOM1, true, "NUMPAD0", LanguageSystem.INPUT_CUSTOM1),
        GENERAL_CUSTOM2(ControlsJoystick.GENERAL_CUSTOM2, true, "NUMPAD1", LanguageSystem.INPUT_CUSTOM2),
        GENERAL_CUSTOM3(ControlsJoystick.GENERAL_CUSTOM3, true, "NUMPAD2", LanguageSystem.INPUT_CUSTOM3),
        GENERAL_CUSTOM4(ControlsJoystick.GENERAL_CUSTOM4, true, "NUMPAD3", LanguageSystem.INPUT_CUSTOM4),
        GENERAL_RELOAD(ControlsJoystick.GENERAL_RELOAD, true, "R", LanguageSystem.INPUT_GUN_RELOAD),
        AIRCRAFT_YAW_R(ControlsJoystick.AIRCRAFT_YAW, false, "L", LanguageSystem.INPUT_YAW_R),
        AIRCRAFT_YAW_L(ControlsJoystick.AIRCRAFT_YAW, false, "J", LanguageSystem.INPUT_YAW_L),
        AIRCRAFT_PITCH_U(ControlsJoystick.AIRCRAFT_PITCH, false, "S", LanguageSystem.INPUT_PITCH_U),
        AIRCRAFT_PITCH_D(ControlsJoystick.AIRCRAFT_PITCH, false, "W", LanguageSystem.INPUT_PITCH_D),
        AIRCRAFT_ROLL_R(ControlsJoystick.AIRCRAFT_ROLL, false, "D", LanguageSystem.INPUT_ROLL_R),
        AIRCRAFT_ROLL_L(ControlsJoystick.AIRCRAFT_ROLL, false, "A", LanguageSystem.INPUT_ROLL_L),
        AIRCRAFT_THROTTLE_U(ControlsJoystick.AIRCRAFT_THROTTLE, false, "I", LanguageSystem.INPUT_THROTTLE_U),
        AIRCRAFT_THROTTLE_D(ControlsJoystick.AIRCRAFT_THROTTLE, false, "K", LanguageSystem.INPUT_THROTTLE_D),
        AIRCRAFT_FLAPS_U(ControlsJoystick.AIRCRAFT_FLAPS_U, true, "Y", LanguageSystem.INPUT_FLAPS_U),
        AIRCRAFT_FLAPS_D(ControlsJoystick.AIRCRAFT_FLAPS_D, true, "H", LanguageSystem.INPUT_FLAPS_D),
        AIRCRAFT_BRAKE(ControlsJoystick.AIRCRAFT_BRAKE, false, "B", LanguageSystem.INPUT_BRAKE),
        AIRCRAFT_PARK(ControlsJoystick.AIRCRAFT_PARK, true, "N", LanguageSystem.INPUT_PARK),
        AIRCRAFT_PANEL(ControlsJoystick.AIRCRAFT_PANEL, true, "U", LanguageSystem.INPUT_PANEL),
        AIRCRAFT_RADIO(ControlsJoystick.AIRCRAFT_RADIO, true, "MINUS", LanguageSystem.INPUT_RADIO),
        AIRCRAFT_GUN_FIRE(ControlsJoystick.AIRCRAFT_GUN_FIRE, false, "SPACE", LanguageSystem.INPUT_GUN_FIRE),
        AIRCRAFT_GUN_SWITCH(ControlsJoystick.AIRCRAFT_GUN_SWITCH, true, "V", LanguageSystem.INPUT_GUN_SWITCH),
        AIRCRAFT_ZOOM_I(ControlsJoystick.AIRCRAFT_ZOOM_I, true, "PRIOR", LanguageSystem.INPUT_ZOOM_I),
        AIRCRAFT_ZOOM_O(ControlsJoystick.AIRCRAFT_ZOOM_O, true, "NEXT", LanguageSystem.INPUT_ZOOM_O),
        AIRCRAFT_CHANGEVIEW(ControlsJoystick.AIRCRAFT_CHANGEVIEW, true, "X", LanguageSystem.INPUT_CHANGEVIEW),
        AIRCRAFT_JS_INHIBIT(ControlsJoystick.AIRCRAFT_JS_INHIBIT, true, "SCROLL", LanguageSystem.INPUT_JS_INHIBIT),
        CAR_MOD(ControlsJoystick.CAR_MOD, false, "RSHIFT", LanguageSystem.INPUT_MOD),
        CAR_TURN_R(ControlsJoystick.CAR_TURN, false, "D", LanguageSystem.INPUT_TURN_R),
        CAR_TURN_L(ControlsJoystick.CAR_TURN, false, "A", LanguageSystem.INPUT_TURN_L),
        CAR_GAS(ControlsJoystick.CAR_GAS, false, "W", LanguageSystem.INPUT_GAS),
        CAR_BRAKE(ControlsJoystick.CAR_BRAKE, false, "S", LanguageSystem.INPUT_BRAKE),
        CAR_PARK(ControlsJoystick.CAR_PARK, true, "N", LanguageSystem.INPUT_PARK),
        CAR_PANEL(ControlsJoystick.CAR_PANEL, true, "U", LanguageSystem.INPUT_PANEL),
        CAR_SHIFT_U(ControlsJoystick.CAR_SHIFT_U, true, "R", LanguageSystem.INPUT_SHIFT_U),
        CAR_SHIFT_D(ControlsJoystick.CAR_SHIFT_D, true, "F", LanguageSystem.INPUT_SHIFT_D),
        CAR_HORN(ControlsJoystick.CAR_HORN, true, "C", LanguageSystem.INPUT_HORN),
        CAR_RADIO(ControlsJoystick.CAR_RADIO, true, "MINUS", LanguageSystem.INPUT_RADIO),
        CAR_GUN_FIRE(ControlsJoystick.CAR_GUN_FIRE, false, "SPACE", LanguageSystem.INPUT_GUN_FIRE),
        CAR_GUN_SWITCH(ControlsJoystick.CAR_GUN_SWITCH, true, "V", LanguageSystem.INPUT_GUN_SWITCH),
        CAR_ZOOM_I(ControlsJoystick.CAR_ZOOM_I, true, "PRIOR", LanguageSystem.INPUT_ZOOM_I),
        CAR_ZOOM_O(ControlsJoystick.CAR_ZOOM_O, true, "NEXT", LanguageSystem.INPUT_ZOOM_O),
        CAR_CHANGEVIEW(ControlsJoystick.CAR_CHANGEVIEW, true, "X", LanguageSystem.INPUT_CHANGEVIEW),
        CAR_LIGHTS(ControlsJoystick.CAR_LIGHTS, true, "NUMPAD5", LanguageSystem.INPUT_LIGHTS),
        CAR_TURNSIGNAL_L(ControlsJoystick.CAR_TURNSIGNAL_L, true, "NUMPAD4", LanguageSystem.INPUT_TURNSIGNAL_L),
        CAR_TURNSIGNAL_R(ControlsJoystick.CAR_TURNSIGNAL_R, true, "NUMPAD6", LanguageSystem.INPUT_TURNSIGNAL_R),
        CAR_JS_INHIBIT(ControlsJoystick.CAR_JS_INHIBIT, true, "SCROLL", LanguageSystem.INPUT_JS_INHIBIT);

        public final boolean isMomentary;
        public final String systemName;
        public final LanguageSystem.LanguageEntry language;
        public final String defaultKeyName;
        public final JSONConfigClient.ConfigKeyboard config;
        private final ControlsJoystick linkedJoystick;
        private boolean wasPressedThisCall;
        private boolean wasPressedLastCall;

        private ControlsKeyboard(ControlsJoystick linkedJoystick, boolean isMomentary, String defaultKeyName, LanguageSystem.LanguageEntry language) {
            this.linkedJoystick = linkedJoystick;
            this.isMomentary = isMomentary;
            this.systemName = this.name().toLowerCase(Locale.ROOT).replaceFirst("_", ".");
            this.language = language;
            this.defaultKeyName = defaultKeyName;
            this.config = ConfigSystem.client.controls.keyboard.containsKey(this.systemName) ? ConfigSystem.client.controls.keyboard.get(this.systemName) : new JSONConfigClient.ConfigKeyboard();
        }

        public boolean isPressed() {
            this.wasPressedLastCall = this.wasPressedThisCall;
            if (this.linkedJoystick.isPressed()) {
                this.wasPressedThisCall = true;
            } else if (this.linkedJoystick.isJoystickActive() && ((Boolean)ConfigSystem.client.controlSettings.kbOverride.value).booleanValue()) {
                this.wasPressedThisCall = false;
            } else {
                this.wasPressedThisCall = InterfaceManager.inputInterface.isKeyPressed(this.config.keyCode);
                if (this.isMomentary && this.wasPressedLastCall) {
                    return false;
                }
            }
            return this.wasPressedThisCall;
        }

        public boolean justReleased() {
            return !this.wasPressedThisCall && this.wasPressedLastCall;
        }
    }

    public static enum ControlsJoystick {
        GENERAL_CUSTOM1(false, true, LanguageSystem.INPUT_CUSTOM1),
        GENERAL_CUSTOM2(false, true, LanguageSystem.INPUT_CUSTOM2),
        GENERAL_CUSTOM3(false, true, LanguageSystem.INPUT_CUSTOM3),
        GENERAL_CUSTOM4(false, true, LanguageSystem.INPUT_CUSTOM4),
        GENERAL_RELOAD(false, true, LanguageSystem.INPUT_GUN_RELOAD),
        AIRCRAFT_CAMLOCK(false, true, LanguageSystem.INPUT_CAMLOCK),
        AIRCRAFT_YAW(true, false, LanguageSystem.INPUT_YAW),
        AIRCRAFT_PITCH(true, false, LanguageSystem.INPUT_PITCH),
        AIRCRAFT_ROLL(true, false, LanguageSystem.INPUT_ROLL),
        AIRCRAFT_THROTTLE(true, false, LanguageSystem.INPUT_THROTTLE),
        AIRCRAFT_BRAKE(true, false, LanguageSystem.INPUT_BRAKE),
        AIRCRAFT_BRAKE_DIGITAL(false, false, LanguageSystem.INPUT_BRAKE),
        AIRCRAFT_GEAR(false, true, LanguageSystem.INPUT_GEAR),
        AIRCRAFT_FLAPS_U(false, true, LanguageSystem.INPUT_FLAPS_U),
        AIRCRAFT_FLAPS_D(false, true, LanguageSystem.INPUT_FLAPS_D),
        AIRCRAFT_PANEL(false, true, LanguageSystem.INPUT_PANEL),
        AIRCRAFT_PARK(false, true, LanguageSystem.INPUT_PARK),
        AIRCRAFT_RADIO(false, true, LanguageSystem.INPUT_RADIO),
        AIRCRAFT_GUN_FIRE(false, false, LanguageSystem.INPUT_GUN_FIRE),
        AIRCRAFT_GUN_SWITCH(false, true, LanguageSystem.INPUT_GUN_SWITCH),
        AIRCRAFT_ZOOM_I(false, true, LanguageSystem.INPUT_ZOOM_I),
        AIRCRAFT_ZOOM_O(false, true, LanguageSystem.INPUT_ZOOM_O),
        AIRCRAFT_CHANGEVIEW(false, true, LanguageSystem.INPUT_CHANGEVIEW),
        AIRCRAFT_LOOK_UD(true, false, LanguageSystem.INPUT_LOOK_UD),
        AIRCRAFT_LOOK_LR(true, false, LanguageSystem.INPUT_LOOK_LR),
        AIRCRAFT_LOOK_L(false, false, LanguageSystem.INPUT_LOOK_L),
        AIRCRAFT_LOOK_R(false, false, LanguageSystem.INPUT_LOOK_R),
        AIRCRAFT_LOOK_U(false, false, LanguageSystem.INPUT_LOOK_U),
        AIRCRAFT_LOOK_D(false, false, LanguageSystem.INPUT_LOOK_D),
        AIRCRAFT_LOOK_A(false, false, LanguageSystem.INPUT_LOOK_A),
        AIRCRAFT_TRIM_YAW_R(false, false, LanguageSystem.INPUT_TRIM_YAW_R),
        AIRCRAFT_TRIM_YAW_L(false, false, LanguageSystem.INPUT_TRIM_YAW_L),
        AIRCRAFT_TRIM_PITCH_U(false, false, LanguageSystem.INPUT_TRIM_PITCH_U),
        AIRCRAFT_TRIM_PITCH_D(false, false, LanguageSystem.INPUT_TRIM_PITCH_D),
        AIRCRAFT_TRIM_ROLL_R(false, false, LanguageSystem.INPUT_TRIM_ROLL_R),
        AIRCRAFT_TRIM_ROLL_L(false, false, LanguageSystem.INPUT_TRIM_ROLL_L),
        AIRCRAFT_REVERSE(false, true, LanguageSystem.INPUT_REVERSE),
        AIRCRAFT_JS_INHIBIT(false, true, LanguageSystem.INPUT_JS_INHIBIT),
        CAR_MOD(false, false, LanguageSystem.INPUT_MOD),
        CAR_CAMLOCK(false, true, LanguageSystem.INPUT_CAMLOCK),
        CAR_TURN(true, false, LanguageSystem.INPUT_TURN),
        CAR_GAS(true, false, LanguageSystem.INPUT_GAS),
        CAR_BRAKE(true, false, LanguageSystem.INPUT_BRAKE),
        CAR_BRAKE_DIGITAL(false, false, LanguageSystem.INPUT_BRAKE),
        CAR_PANEL(false, true, LanguageSystem.INPUT_PANEL),
        CAR_SHIFT_U(false, true, LanguageSystem.INPUT_SHIFT_U),
        CAR_SHIFT_D(false, true, LanguageSystem.INPUT_SHIFT_D),
        CAR_SHIFT_1(false, false, LanguageSystem.INPUT_SHIFT_1),
        CAR_SHIFT_2(false, false, LanguageSystem.INPUT_SHIFT_2),
        CAR_SHIFT_3(false, false, LanguageSystem.INPUT_SHIFT_3),
        CAR_SHIFT_4(false, false, LanguageSystem.INPUT_SHIFT_4),
        CAR_SHIFT_5(false, false, LanguageSystem.INPUT_SHIFT_5),
        CAR_SHIFT_6(false, false, LanguageSystem.INPUT_SHIFT_6),
        CAR_SHIFT_7(false, false, LanguageSystem.INPUT_SHIFT_7),
        CAR_SHIFT_8(false, false, LanguageSystem.INPUT_SHIFT_8),
        CAR_SHIFT_9(false, false, LanguageSystem.INPUT_SHIFT_9),
        CAR_SHIFT_R(false, false, LanguageSystem.INPUT_SHIFT_R),
        CAR_HORN(false, true, LanguageSystem.INPUT_HORN),
        CAR_PARK(false, true, LanguageSystem.INPUT_PARK),
        CAR_RADIO(false, true, LanguageSystem.INPUT_RADIO),
        CAR_GUN_FIRE(false, false, LanguageSystem.INPUT_GUN_FIRE),
        CAR_GUN_SWITCH(false, true, LanguageSystem.INPUT_GUN_SWITCH),
        CAR_ZOOM_I(false, true, LanguageSystem.INPUT_ZOOM_I),
        CAR_ZOOM_O(false, true, LanguageSystem.INPUT_ZOOM_O),
        CAR_CHANGEVIEW(false, true, LanguageSystem.INPUT_CHANGEVIEW),
        CAR_LOOK_UD(true, false, LanguageSystem.INPUT_LOOK_UD),
        CAR_LOOK_LR(true, false, LanguageSystem.INPUT_LOOK_LR),
        CAR_LOOK_L(false, false, LanguageSystem.INPUT_LOOK_L),
        CAR_LOOK_R(false, false, LanguageSystem.INPUT_LOOK_R),
        CAR_LOOK_U(false, false, LanguageSystem.INPUT_LOOK_U),
        CAR_LOOK_D(false, false, LanguageSystem.INPUT_LOOK_D),
        CAR_LOOK_A(false, false, LanguageSystem.INPUT_LOOK_A),
        CAR_LIGHTS(false, true, LanguageSystem.INPUT_LIGHTS),
        CAR_TURNSIGNAL_L(false, true, LanguageSystem.INPUT_TURNSIGNAL_L),
        CAR_TURNSIGNAL_R(false, true, LanguageSystem.INPUT_TURNSIGNAL_R),
        CAR_JS_INHIBIT(false, true, LanguageSystem.INPUT_JS_INHIBIT);

        public final boolean isAxis;
        public final boolean isMomentary;
        public final String systemName;
        public final LanguageSystem.LanguageEntry language;
        public final JSONConfigClient.ConfigJoystick config;
        private boolean wasPressedLastCall;

        private ControlsJoystick(boolean isAxis, boolean isMomentary, LanguageSystem.LanguageEntry language) {
            this.isAxis = isAxis;
            this.isMomentary = isMomentary;
            this.systemName = this.name().toLowerCase(Locale.ROOT).replaceFirst("_", ".");
            this.language = language;
            this.config = ConfigSystem.client.controls.joystick.containsKey(this.systemName) ? ConfigSystem.client.controls.joystick.get(this.systemName) : new JSONConfigClient.ConfigJoystick();
        }

        public boolean isJoystickActive() {
            return !joysticksInhibited && InterfaceManager.inputInterface.isJoystickPresent(this.config.joystickName);
        }

        public boolean isPressed() {
            if (this.isJoystickActive()) {
                if (this.isMomentary) {
                    if (this.wasPressedLastCall) {
                        this.wasPressedLastCall = InterfaceManager.inputInterface.getJoystickButtonValue(this.config.joystickName, this.config.buttonIndex);
                        return false;
                    }
                    this.wasPressedLastCall = InterfaceManager.inputInterface.getJoystickButtonValue(this.config.joystickName, this.config.buttonIndex);
                    return this.wasPressedLastCall;
                }
                return InterfaceManager.inputInterface.getJoystickButtonValue(this.config.joystickName, this.config.buttonIndex);
            }
            return false;
        }

        private float getMultistateValue() {
            return InterfaceManager.inputInterface.getJoystickAxisValue(this.config.joystickName, this.config.buttonIndex);
        }

        private double getAxisState(boolean ignoreDeadzone) {
            double pollValue = this.getMultistateValue();
            if (this.config.axisMaxTravel != this.config.axisMinTravel && (ignoreDeadzone || Math.abs(pollValue) > (Double)ConfigSystem.client.controlSettings.joystickDeadZone.value)) {
                pollValue = Math.max(this.config.axisMinTravel, pollValue);
                pollValue = Math.min(this.config.axisMaxTravel, pollValue);
                pollValue = (pollValue - this.config.axisMinTravel) / (this.config.axisMaxTravel - this.config.axisMinTravel);
                if (this.config.invertedAxis) {
                    pollValue = 1.0 - pollValue;
                }
                return pollValue;
            }
            return 0.0;
        }

        public void setControl(String joystickName, int buttonIndex) {
            this.config.joystickName = joystickName;
            this.config.buttonIndex = buttonIndex;
            ConfigSystem.client.controls.joystick.put(this.systemName, this.config);
            ConfigSystem.saveToDisk();
        }

        public void setAxisControl(String joystickName, int buttonIndex, double axisMinTravel, double axisMaxTravel, boolean invertedAxis) {
            this.config.axisMinTravel = axisMinTravel;
            this.config.axisMaxTravel = axisMaxTravel;
            this.config.invertedAxis = invertedAxis;
            this.setControl(joystickName, buttonIndex);
        }

        public void clearControl() {
            this.setControl(null, 999);
        }
    }

    public static enum ControlsKeyboardDynamic {
        CAR_SLOW(ControlsKeyboard.CAR_GAS, ControlsKeyboard.CAR_MOD, LanguageSystem.INPUT_SLOW),
        CAR_SHIFT_NU(ControlsKeyboard.CAR_SHIFT_U, ControlsKeyboard.CAR_MOD, LanguageSystem.INPUT_SHIFT_N),
        CAR_SHIFT_ND(ControlsKeyboard.CAR_SHIFT_D, ControlsKeyboard.CAR_MOD, LanguageSystem.INPUT_SHIFT_N);

        public final LanguageSystem.LanguageEntry language;
        public final ControlsKeyboard mainControl;
        public final ControlsKeyboard modControl;

        private ControlsKeyboardDynamic(ControlsKeyboard mainControl, ControlsKeyboard modControl, LanguageSystem.LanguageEntry language) {
            this.language = language;
            this.mainControl = mainControl;
            this.modControl = modControl;
        }

        public boolean isPressed() {
            return this.modControl.isPressed() && this.mainControl.isPressed();
        }
    }
}

